//Worst-Fit Memory Allocation, the operating system searches the entire list and allocates the largest available hole to the process. 
//If a large process comes at a later stage, then memory may not have space to accommodate it.

function [wf_allot]=worstFit(p,b,size_process, size_block)
   
// Declaring worst fit flag array(wf_flag) which is used for maintaining the status of each block(free or busy)
    
    wf_allot = zeros(1,size_process);               // Declaring worst fit array(wf_allot)
    wf_flag = zeros(1,size_block);
    
//For loop for allocating blocks according to worst fit 

    for i=1:size_process
        k = -1;                    // k - index position of the largest block which can accommodate a process, initially set to -1
        for j=1:size_block
            if p(i)<=b(j) && wf_flag(j) == 0 then // if process size is less than block size and block is free
                if k==-1 then
                    k = j;          // update k with index positioin of the block
                elseif(b(k)<b(j))   // if there is a larger block which can accommodate the process
                    k = j; // update k with the index position of the larger block 
                end,
            end,         
        end
        if(k==-1)
            wf_allot(i)=0; // if no block can accomodate the process, set allotted block number as 0
        else
            wf_allot(i) = k; // store the selected index in the worst fit array in the index position i(process number)
            wf_flag(k) = 1; // set the status of the selected block as busy
        end,
    end
endfunction
